package service;


public abstract class SimpleState extends State {
	/** Create a new state
	 * @param name the name that identifies the state
	 * @param isInitial this argument is true if the new state is an initial state
	 * @param isFinal  this argument is true if the new state is a final state
	 */
	public SimpleState(String name,boolean isInitial,boolean isFinal){
		super(name);
	}
	/** Returns if the current state is final or not.
	 * @return returns true if the state is final else return false
	 */
	public abstract boolean isFinal();
	/** Returns if the current state is a initial state.
	 * @return returns true if the state is a initials state else return false
	 */
	public abstract boolean isInitial();
	/**
	 * This method returns the hashCode of the state
	 * @return The string contains the hashCode of the state
	 */
	public int hashCode(){
		return super.hashCode();
	}
	/**
	 * This method compares a state with another object
	 * 
	 * @param obj the other object used by the comparison
	 * @return Return true if and only if obj is a State and the attributes of the two State are equals.
	 */
	public boolean equals(Object obj){
		return super.equals(obj);
	};
	/** Set the property "initial" of the state
	 * @param initialstate initialstate is true if we want set the state as an initial state else this argument is false 
	 */
	public abstract void setInitial(boolean initialstate);
	/** Set the property "final" of the state
	 * @param finalstate finalstate is true if we want set the state as a final state else this argument is false 
	 */
	public abstract void setFinal(boolean finalstate);
}
